/*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * Freescale Confidential Proprietary
 * \file    mcu_hw_config.c
 * \brief   MCU Hardware configuration routines.
 * \author  a20639
 * \version 4.1a
 * \date    2005/08/11 20:44:37 
 * 
 * \b Description:
 *
 * This file contains the functions to manage the clock, 
 * COP, GPIO, SPI and IRQ. 
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 11/16/2005 Doc. update to Doxygen compliant by Gonzalo Delgado 
 * Huitron rgd04c
 */ 

#include "hprfgw_config.h"
#if defined (OS_WINCE)
 #include <windows.h>
 #include <types.h>
 #include <ceddk.h>
 #include <ddkreg.h>
 #include <serhw.h>
 #include <bsp.h>
 #include "hprf_winceIntfc.h"
#elif defined (OS_NUCLEUS)
 #include "system.h"
#endif
#include "smac_mcu_hw_config.h"
#include "smac_simple_phy.h"
#include "smac_mcu_spi_config.h"
#include "smac_drivers.h"
#if defined (OS_NUCLEUS)
 #include "mcf5271.h"
 #include <nucleus.h>
#endif
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfSlaveIntToHost.h"
#include "hprfgw_rfSlaveIntToRfApp.h"

/*! Global Variables */

// ISR Details
/* Bit definitions and macros for MCF_INTC0_ICRn */
#define MCF_INTC0_ICRn_IP(x)          (((x)&0x07)<<0)
#define MCF_INTC0_ICRn_IL(x)          (((x)&0x07)<<3)
#define MC13192PHY_INTLEV		       (MCF_INTC0_ICRn_IL(6)|MCF_INTC0_ICRn_IP(7))  // fixed because it's an Ext Interrupt
#define MC13192PHY_VECT			       (70)	
#define MC13192_HISR_PRIORITY      (1)



/* Defines */
// For now, hardcode the values. Use the coldfire .h files later on
// RxTx, Attn, PAEnable, AnswTxEn, AntSwRxEn, GPIO5, GPIO6, Reset pin mask 
// These are specific to the TPS6x
#define gMC1319xAttnMask_c   		(1<<0)
#define gMC1319xResetMask_c  		(1<<1)
#define gMC1319xRxTxMask_c   		(1<<2)
#define gMC1319xAntSwRxEnMask_c  	(1<<3)	
#define gMC1319xAntSwTxEnMask_c  	(1<<4)	
#define gMC1319xPAEnMask_c  		(1<<5)						 
#define gMC1319xGPIO1Mask_c  		(1<<6)							 
#define gMC1319xGPIO2Mask_c  		(1<<7)

#if defined (OS_NUCLEUS)
 RFPHYISRSTRUCT RFPhyISR;
#elif defined (OS_WINCE)
 DWORD HPR_IntrThread(VOID *pContext);
#endif

#if defined (OS_NUCLEUS)
void EnableInterrupt(BOOL hi, UINT32 mask)
{

}

// Use for individual interrupts only.
void DisableInterrupt(BOOL hi, UINT32 mask)
{

}
#endif

#if 0	/* Not used, so why confuse people */
/*
 * MC13192Restart: Restart the MC13192.
 *
 * Parameters: None
 *
 * Return : None
 */
void MC13192Restart()
{
    //UINT8 u8AttnIrq =0; //mod
    //UINT16 u8AttnIrq = 0; //mod

    gu8RTxMode = SYSTEM_RESET_MODE;
    
    // MNT - 4/5/2007 - Assert the reset?
    /// \review this = this should be cleaned up
    MC13192_IRQ_Disable();
    MC1319xDrv_Assert_Reset();
    SMAC_IRQInit();                  /* Turn on the IRQ pin. */
    MC1319xDrv_Deassert_Reset();          /* Take MC13192 out of reset */
    while (IRQFLAG() == 0)     /* Poll waiting for MC13192 to assert the irq */
        ; /* Empty Body */      /* (i.e. ATTN). */
    (void)SPIDrvRead(0x24);            /* Clear MC13192 interrupts */
    IRQACK();                   /* ACK the pending IRQ interrupt */
#if defined (OS_WINCE)
    #error "RQPinEnable() can not be used from here. Revisit" 
#endif
    IRQPinEnable();             /* Pin Enable, IE, IRQ CLR, negative edge. */    
}
#endif /* #if 0 */

/*
 * MC13192ContReset: Reset (continuous) the MC13192.
 *
 * Parameters: None
 *
 * Return : None
 */
void MC13192ContReset()
{
    gu8RTxMode = SYSTEM_RESET_MODE;
    //IRQSC = 0x00;                   /* Set for negative edge. */
    MC1319xDrv_Assert_Reset();        /* Place the MC13192 into reset */
}



/*!
  \fn void GPIOInit()
  \brief Initialize the MCU-to-MC13192 GPIO direction and data.
*/
void SMAC_GPIOInit()
{
    // MNT - 4/5/2007 - Set up RxTx, Attn, PAEnable, AnswTxEn, AntSwRxEn, GPIO5, GPIO6, Reset
    // as outputs

    // Setup required GPIOs - configured as output on winceintfc.c file already
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_RXEN, 1);
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_TX_EN, 1);
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_ATTN, 0);
}


/**
 *
 * \date        04-05-2007
 *
 * \author      MNT - Adapted from HS
 *
 * \brief       Assert the reset pin
 *
 * \detail      Active Low
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param void 
 */
void MC1319xDrv_Assert_Reset(void)
{
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_RESET, 0);
}

/**
 *
 * \date        04-05-2007
 *
 * \author      MNT - Adapted from HS
 *
 * \brief       Deassert the reset pin
 *
 * \detail      Active Low
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param void 
 */
void MC1319xDrv_Deassert_Reset(void)
{
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_RESET, 1);
}




/**
 *
 * \date        04-05-2007
 *
 * \author      mtalreja
 *
 * \brief       IRQFLAG
 *
 * \detail      Indicates if the interrupt has occured. Returns true if IRQ line is 0
 *
 * \return      UINT8
 *
 * \retval      1 - Occured
 *              0 - Not Occured
 *
 * \param void 
 * \return 
 */
UINT8 IRQFLAG(void)
{
    DWORD val = 0;
  
    // Read the pin directly
    DDKGpioReadDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_IRQ, &val);

    if (val)
        return 0;
    else
        return 1;
}










/**
 *
 * \date        04-05-2007
 *
 * \author      mtalreja
 *
 * \brief       Initialize the IRQ6
 *
 * \detail      
 *
 * \return      
 *
 * \retval      
 *
 * \param void 
 */
void SMAC_IRQInit(void)
{
    // Create Interrupt Handler Thread
    pHPRDevice->dwHprfIntrId = HPRF_IRQ_ID;

    if (!KernelIoControl(
            IOCTL_HAL_REQUEST_SYSINTR, &pHPRDevice->dwHprfIntrId, sizeof(pHPRDevice->dwHprfIntrId),
            &pHPRDevice->dwHprfSysintr, sizeof(pHPRDevice->dwHprfSysintr), NULL) )
    {
        RFIntHostApp.pF_ErrorPrintf("SMAC_IRQInit: Failed to map HPRF interrupt (%d)", pHPRDevice->dwHprfIntrId);
        goto cleanUp;
    }

    // allocate the interrupt event for radio
    pHPRDevice->hHprfIntrEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

    if (NULL == pHPRDevice->hHprfIntrEvent)
    {
        RFIntHostApp.pF_ErrorPrintf("SMAC_IRQInit: Failed to create HPRF interrupt event");
        goto cleanUp;
    }

    // Initialize interrupt
    if (!InterruptInitialize(pHPRDevice->dwHprfSysintr, pHPRDevice->hHprfIntrEvent, NULL, 0))
    {
        RFIntHostApp.pF_ErrorPrintf("SMAC_IRQInit: InterruptInitialize failed");
        goto cleanUp;
    }

    // Start interrupt service thread
    pHPRDevice->intrThreadExit = FALSE;
    pHPRDevice->hHprfIntrThread = CreateThread(NULL, 0, HPR_IntrThread, pHPRDevice, 0,NULL);
    if (!pHPRDevice->hHprfIntrThread)
    {
        RFIntHostApp.pF_ErrorPrintf("SMAC_IRQInit: Failed create interrupt thread");
        goto cleanUp;
    }
    // Set thread priority
    CeSetThreadPriority(pHPRDevice->hHprfIntrThread, RF_INTR_THREAD_PRIORITY);

cleanUp:
    return;
}



void MC13192_IRQ_Disable(void)
{
    //InterruptDone(pHPRDevice->dwHprfSysintr);
    //InterruptDisable(pHPRDevice->dwHprfSysintr);
    InterruptMask(pHPRDevice->dwHprfSysintr, 1);
}



void MC13192_IRQ_Enable(void)
{
    // Initialize interrupt
    //if (!InterruptInitialize(pHPRDevice->dwHprfSysintr, pHPRDevice->hHprfIntrEvent, NULL, 0))
    //{
    //	DEBUGMSG (ZONE_ERROR, (L"ERROR: MC13192_IRQ_Enable: "
    //			  L"InterruptInitialize failed\r\n"));
    //}
    InterruptMask(pHPRDevice->dwHprfSysintr, 0);
}




void IRQPinEnable(void)
{
    DDKIomuxSetPinMux(DDK_IOMUX_PIN_PATA_DATA15, DDK_IOMUX_PIN_MUXMODE_ALT1, DDK_IOMUX_PIN_SION_REGULAR);
    DDKIomuxSetPadConfig(DDK_IOMUX_PAD_PATA_DATA15, DDK_IOMUX_PAD_SLEW_NULL, DDK_IOMUX_PAD_DRIVE_LOW,
                         DDK_IOMUX_PAD_OPENDRAIN_DISABLE,  DDK_IOMUX_PAD_PULL_NONE,
                         DDK_IOMUX_PAD_HYSTERESIS_ENABLE, DDK_IOMUX_PAD_VDOEN_NULL, DDK_IOMUX_PAD_OUTVOLT_NULL);
    DDKGpioSetConfig(HPRF_GPIO_PORT, HPRF_GPIONUM_N_IRQ, DDK_GPIO_DIR_IN, DDK_GPIO_INTR_LOW_LEV);
    DDKGpioClearIntrPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_IRQ);
}


void IRQACK(void)
{
    // For WINCE, this may not be needed
    // as the flag is cleared in the ISR itself.
    // Interrupt is done
    InterruptDone(pHPRDevice->dwHprfSysintr);
}







 /*!
  \fn void MCUInit() 
  \brief	Initialize the MCU COP, GPIO, SPI and IRQ.
   Set the desired MC13192 clock frequency here.
  \sa GPIOInit()
  \sa SPIInit()
  \sa IRQInit()
  \sa IRQACK()             
  \sa SPIDrvRead()
  \sa IRQPinEnable() 
*/

 /*!
  \fn UINT8 IRQPinLow() 
  \brief	Checks IRQ Pin to see if is low.
  \return	1 if IRQ is Low   
   
*/
UINT8 IRQPinLow(void)
{
    return IRQFLAG();
}

//#pragma INLINE
//void AssertCE(void){
//  MC13192_CE = 0; /*!< Asserts the MC13192 CE pin */
//}
//#pragma INLINE
//void DeAssertCE(void){
//  MC13192_CE = 1; /*!< Deasserts the MC13192 CE pin */
//}

void RTXENDeAssert(void)
{
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_RXTXEN, 0);

    // Delay needed? TODO
    RFIntHostApp.pF_HwDelayUsec(20);
}

void RTXENAssert(void)
{
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_RXTXEN, 1);
}

void MC13192Wake(void)
{
    /*!< Assert ATTN */ 
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_ATTN, 1);

    /*!< Deassert ATTN */
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_ATTN, 0);
}



void MCU_LOW_POWER_WHILE(void)
{
    StallExecution(10);
}



#if defined (OS_NUCLEUS)
// MNT - 4/6/2007 - QSPI CS is now configured as a GPIO
__inline void AssertCE(void)
{
    // For WinCE, the SPI driver takes care of it
}

__inline void DeAssertCE(void)
{
    // For WinCE, the SPI driver takes care of it
}
#endif



void MC1319xDrv_TxHighPowerEnable(void)
{
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_PAEN, 1);
}


void MC1319xDrv_TxHighPowerDisable(void)
{
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_PAEN, 0);
}

void MC1319xDrv_RxAntennaSwitchEnable(void)
{ 
    MC1319xDrv_TxHighPowerDisable();

    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_TX_EN, 1);
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_RXEN, 0);
}

void MC1319xDrv_TxAntennaSwitchEnable(void)
{ 
    MC1319xDrv_TxHighPowerEnable();

    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_RXEN, 1);
    DDKGpioWriteDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_N_TX_EN, 0);
}


/**
 *
 * \date        01-21-2008
 * \author      mtalreja
 * \brief       MC13192ReadGPIOStatus
 * \detail      Returns the GPIO status in the lower 3 bits - data is in PPDSDR register
 * \return      0 = low, 1 = high
 * \retval      
 * \warning     
 * \note        
 *
 * \param void 
 * \return 
 */
UINT8 MC13192ReadGPIO1_3Status(void)
{
    UINT8 retval;
    //DWORD gpioNum;
    DWORD val = 0;

    retval = 0;
  
    DDKGpioReadDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_FCC_ID01, &val);

    // ID1 in zero bit
    retval |= val;

    DDKGpioReadDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_FCC_ID02, &val);

    // ID2 in 1st bit
    retval |= (val << 1);

    DDKGpioReadDataPin(HPRF_GPIO_PORT, HPRF_GPIONUM_FCC_ID03, &val);

    // ID3 in 2nd bit
    retval |= (val << 2);

    return retval;
}
